; NCL file created by ./ctl2ncl.rb

; Longitude co-ordinate
; ................
  nlon=1
  lon=(/0/)
  lon!0="lon"
  lon&lon=lon
  lon@units="degrees_east"
  lon@long_name="Longitude"
  printVarSummary(lon)

; Latitude co-ordinate
; ................
  nlat=395
  lat=(/-79.2205200195312,-78.6863098144531,-78.1520919799805,-77.6178741455078,-77.0836563110352,-76.5494384765625,-76.0152206420898,-75.4810028076172,-74.9467849731445,-74.4125671386719,-73.8783493041992,-73.3441314697266,-72.8099136352539,-72.2756958007812,-71.7414779663086,-71.2072601318359,-70.6730346679688,-70.1388168334961,-69.6045989990234,-69.0703735351562,-68.5361557006836,-68.0019302368164,-67.4677124023438,-66.9334869384766,-66.3992691040039,-65.8650436401367,-65.3308258056641,-64.7966003417969,-64.2623748779297,-63.7281494140625,-63.1939277648926,-62.6597023010254,-62.1254768371582,-61.591251373291,-61.0570220947266,-60.5227966308594,-59.9885711669922,-59.4543418884277,-58.9201164245605,-58.3858871459961,-57.8516578674316,-57.3174285888672,-56.7831993103027,-56.2489700317383,-55.7147407531738,-55.1805076599121,-54.6462783813477,-54.1120452880859,-53.5778121948242,-53.0435791015625,-52.5093460083008,-51.9751129150391,-51.4408798217773,-50.9066467285156,-50.3724098205566,-49.8381767272949,-49.3039398193359,-48.769702911377,-48.235466003418,-47.701229095459,-47.1669921875,-46.6327514648438,-46.0985145568848,-45.5642738342285,-45.0300331115723,-44.4957962036133,-43.961555480957,-43.4273109436035,-42.8930702209473,-42.358829498291,-41.8245849609375,-41.2903442382812,-40.7560997009277,-40.2218551635742,-39.6876106262207,-39.1533660888672,-38.6191215515137,-38.0848731994629,-37.5506286621094,-37.0163803100586,-36.4821357727051,-35.9478874206543,-35.4136390686035,-34.8793907165527,-34.3451385498047,-33.8108901977539,-33.2766418457031,-32.7423896789551,-32.2081451416016,-31.6740627288818,-31.1407585144043,-30.6091709136963,-30.0802154541016,-29.5547637939453,-29.0336418151855,-28.5176162719727,-28.0073890686035,-27.503589630127,-27.0067710876465,-26.5174102783203,-26.0359134674072,-25.5625991821289,-25.0977249145508,-24.641471862793,-24.1939563751221,-23.7552375793457,-23.3253192901611,-22.9041500091553,-22.4916439056396,-22.08766746521,-21.6920585632324,-21.3046283721924,-20.9251575469971,-20.5534114837646,-20.189136505127,-19.8320693969727,-19.4819355010986,-19.13844871521,-18.8013248443604,-18.4702701568604,-18.1449947357178,-17.8252048492432,-17.5106086730957,-17.2009162902832,-16.8958415985107,-16.5950984954834,-16.2984066009521,-16.0054912567139,-15.7160758972168,-15.4298934936523,-15.1466779708862,-14.8661670684814,-14.5881042480469,-14.3122339248657,-14.0383052825928,-13.7660684585571,-13.4952774047852,-13.2256889343262,-12.9570608139038,-12.6891508102417,-12.4217205047607,-12.1545286178589,-11.887396812439,-11.620265007019,-11.3531332015991,-11.0860013961792,-10.8188695907593,-10.5517377853394,-10.2846050262451,-10.0174732208252,-9.75034141540527,-9.48320865631104,-9.21607685089111,-8.94894409179688,-8.68181228637695,-8.41467952728271,-8.14754772186279,-7.88041543960571,-7.61328268051147,-7.34615039825439,-7.07901811599731,-6.81188535690308,-6.544753074646,-6.27762031555176,-6.01048755645752,-5.74335527420044,-5.4762225151062,-5.20908975601196,-4.94195699691772,-4.67482423782349,-4.40769147872925,-4.14055919647217,-3.87342619895935,-3.60629343986511,-3.33916068077087,-3.07202792167664,-2.80489492416382,-2.53776216506958,-2.27062940597534,-2.00349640846252,-1.73636364936829,-1.46923077106476,-1.20209789276123,-0.934965074062347,-0.66783219575882,-0.400699317455292,-0.133566439151764,0.133566439151764,0.400699317455292,0.66783219575882,0.934965074062347,1.20209789276123,1.46923077106476,1.73636364936829,2.00349640846252,2.27062940597534,2.53776216506958,2.80489492416382,3.07202792167664,3.33916068077087,3.60629343986511,3.87342619895935,4.14055919647217,4.40769147872925,4.67482423782349,4.94195699691772,5.20908975601196,5.4762225151062,5.74335527420044,6.01048755645752,6.27762031555176,6.544753074646,6.81188535690308,7.07901811599731,7.34615039825439,7.61328268051147,7.88041543960571,8.14754772186279,8.41467952728271,8.68181228637695,8.94894409179688,9.21607685089111,9.48320865631104,9.75034141540527,10.0174732208252,10.2846050262451,10.5517377853394,10.8188695907593,11.0860013961792,11.3531332015991,11.620265007019,11.887396812439,12.1545286178589,12.4217205047607,12.6891508102417,12.9570608139038,13.2256889343262,13.4952774047852,13.7660684585571,14.0383052825928,14.3122339248657,14.5881042480469,14.8661670684814,15.1466779708862,15.4298934936523,15.7160758972168,16.0054912567139,16.2984066009521,16.5950984954834,16.8958415985107,17.2009162902832,17.5106086730957,17.8252048492432,18.1449947357178,18.4702701568604,18.8013248443604,19.13844871521,19.4819355010986,19.8320693969727,20.189136505127,20.5534114837646,20.9251575469971,21.3046283721924,21.6920585632324,22.08766746521,22.4916439056396,22.9041500091553,23.3253192901611,23.7552375793457,24.1939563751221,24.641471862793,25.0977249145508,25.5625991821289,26.0359134674072,26.5174102783203,27.0067710876465,27.503589630127,28.0073890686035,28.5176162719727,29.0336418151855,29.5547637939453,30.0802154541016,30.6091709136963,31.1407585144043,31.6740627288818,32.2081451416016,32.7423896789551,33.2766418457031,33.8108901977539,34.3451385498047,34.8793907165527,35.4136390686035,35.9478874206543,36.4821357727051,37.0163803100586,37.5506286621094,38.0848731994629,38.6191215515137,39.1533660888672,39.6876106262207,40.2218551635742,40.7560997009277,41.2903442382812,41.8245849609375,42.358829498291,42.8930702209473,43.4273109436035,43.961555480957,44.4957962036133,45.0300331115723,45.5642738342285,46.0985145568848,46.6327514648438,47.1669921875,47.701229095459,48.235466003418,48.769702911377,49.3039398193359,49.8381767272949,50.3724098205566,50.9066467285156,51.4408798217773,51.9751129150391,52.5093460083008,53.0435791015625,53.5778121948242,54.1120452880859,54.6462783813477,55.1805076599121,55.7147407531738,56.2489700317383,56.7831993103027,57.3174285888672,57.8516578674316,58.3858871459961,58.9201164245605,59.4543418884277,59.9885711669922,60.5227966308594,61.0570220947266,61.591251373291,62.1254768371582,62.6597023010254,63.1939277648926,63.7281494140625,64.2623748779297,64.7966003417969,65.3308258056641,65.8650436401367,66.3992691040039,66.9334869384766,67.4677124023438,68.0019302368164,68.5361557006836,69.0703735351562,69.6045989990234,70.1388168334961,70.6730346679688,71.2072601318359,71.7414779663086,72.2756958007812,72.8099136352539,73.3441314697266,73.8783493041992,74.4125671386719,74.9467849731445,75.4810028076172,76.0152206420898,76.5494384765625,77.0836563110352,77.6178741455078,78.1520919799805,78.6863098144531,79.2205200195312,79.7547378540039,80.2889556884766,80.8231735229492,81.3573913574219,81.8916091918945,82.4258270263672,82.9600448608398,83.4942626953125,84.0284805297852,84.5626983642578,85.0969161987305,85.6311340332031,86.1653518676758,86.6995697021484,87.2337875366211,87.7680053710938,88.3022232055664,88.8364410400391,89.3706588745117,89.9048767089844,90/)
  lat!0="lat"
  lat&lat=lat
  lat@units="degrees_north"
  lat@long_name="Latitude"
  printVarSummary(lat)

; Z co-ordinate
; ................
  nlev=1
  lev=(/0/)
  lev!0="lev"
  lev&lev=lev
  lev@units="m" ; this is for GrADs
  lev@long_name="z-levels"
  lev@original_units = "unknown ... please fill in"
  printVarSummary(lev)

; T co-ordinate
; ................
  ntim=12
  time=fspan(0.5,11.5,ntim)
  time!0="time"
  time&time=time
  time@units="months since 0000-1-1 0:0"
  time@long_name="time"
  printVarSummary(time)

; Open the binary data file
  setfileoption("bin","ReadByteOrder","BigEndian")
  path="./htocbsnLGM.dat"
  rec_dims=(/nlat,nlon/)
  rec_type="float"

      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=1      
  htat=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
    rec_num=it*6
    rec_num=rec_num+0
    do il=0,nens-1
      htat(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  htat@units="Atlantic"      
  htat@long_name=""      
  htat!0="time"
  htat!1="lev"
  htat!2="lat"
  htat!3="lon"
  htat&lon=lon
  htat&lat=lat
  htat&lev=lev(:nens-1)
  htat&time=tim2
  htat@_FillValue=1.0e20
  htat@missing_value=1.0e20
      
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=1      
  htpc=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
    rec_num=it*6
    rec_num=rec_num+1
    do il=0,nens-1
      htpc(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  htpc@units="Pacific"      
  htpc@long_name=""      
  htpc!0="time"
  htpc!1="lev"
  htpc!2="lat"
  htpc!3="lon"
  htpc&lon=lon
  htpc&lat=lat
  htpc&lev=lev(:nens-1)
  htpc&time=tim2
  htpc@_FillValue=1.0e20
  htpc@missing_value=1.0e20
      
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=1      
  htid=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
    rec_num=it*6
    rec_num=rec_num+2
    do il=0,nens-1
      htid(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  htid@units="Indian"      
  htid@long_name=""      
  htid!0="time"
  htid!1="lev"
  htid!2="lat"
  htid!3="lon"
  htid&lon=lon
  htid&lat=lat
  htid&lev=lev(:nens-1)
  htid&time=tim2
  htid@_FillValue=1.0e20
  htid@missing_value=1.0e20
      
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=1      
  htgo=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
    rec_num=it*6
    rec_num=rec_num+3
    do il=0,nens-1
      htgo(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  htgo@units="Ocean"      
  htgo@long_name="Global"      
  htgo!0="time"
  htgo!1="lev"
  htgo!2="lat"
  htgo!3="lon"
  htgo&lon=lon
  htgo&lat=lat
  htgo&lev=lev(:nens-1)
  htgo&time=tim2
  htgo@_FillValue=1.0e20
  htgo@missing_value=1.0e20
      
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=1      
  htbs=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
    rec_num=it*6
    rec_num=rec_num+4
    do il=0,nens-1
      htbs(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  htbs@units="Strait"      
  htbs@long_name="Bering"      
  htbs!0="time"
  htbs!1="lev"
  htbs!2="lat"
  htbs!3="lon"
  htbs&lon=lon
  htbs&lat=lat
  htbs&lev=lev(:nens-1)
  htbs&time=tim2
  htbs@_FillValue=1.0e20
  htbs@missing_value=1.0e20
      
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=1      
  htit=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
    rec_num=it*6
    rec_num=rec_num+5
    do il=0,nens-1
      htit(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  htit@units="Indonesian"      
  htit@long_name=""      
  htit!0="time"
  htit!1="lev"
  htit!2="lat"
  htit!3="lon"
  htit&lon=lon
  htit&lat=lat
  htit&lev=lev(:nens-1)
  htit&time=tim2
  htit@_FillValue=1.0e20
  htit@missing_value=1.0e20
      
; Write out as a NetCDF file 
;fout=addfile("brady.nc","c") 
;fout->htat=htat(:,0,:,:) 
;fout->htpc=htpc(:,0,:,:) 
;fout->htid=htid(:,0,:,:) 
;fout->htgo=htgo(:,0,:,:) 
;fout->htbs=htbs(:,0,:,:) 
;fout->htit=htit(:,0,:,:) 
